#!/bin/bash

# List of packages with their versions
packages=(
    "TiffFile=2023.12.9" "alabaster=1.0.0" "astroid=3.3.5" "babel=2.16.0"
    "combat=0.3.3" "dask=2023.12.1" "dill=0.3.9" "docutils=0.21.2"
    "fast-histogram=0.14" "flake8=7.1.1" "gendocs=0.4.0" "gensim=4.3.3"
    "ghp-import=2.1.0" "imagesize=1.4.1" "iniconfig=2.0.0" "isort=5.13.2"
    "llvmlite=0.41.1" "markdown=3.7" "mccabe=0.7.0" "mergedeep=1.3.4"
    "mkdocs=1.6.1" "mkdocs-get-deps=0.2.0" "mkdocs-material=9.5.42"
    "mkdocs-material-extensions=1.3.1" "mpl-scatter-density=0.7"
    "mpmath=1.3.0" "numba=0.58.1" "numpy=1.26.4" "paginate=0.5.7"
    "pathspec=0.12.1" "phenograph=1.5.7" "platformdirs=4.3.6"
    "pluggy=1.5.0" "properties=0.6.1" "pycodestyle=2.12.1" "pyflakes=3.2.0"
    "pylint=3.3.1" "pymdown-extensions=10.12" "pytest=7.4.4"
    "pytest-xvfb=3.0.0" "pyvirtualdisplay=3.0" "pyyaml-env-tag=0.1"
    "regex=2024.9.11" "scimap=2.1.3" "scipy=1.12.0" "shapely=2.0.6"
    "smart-open=7.0.5" "snowballstemmer=2.2.0" "sphinx=8.1.3"
    "sphinxcontrib-applehelp=2.0.0" "sphinxcontrib-devhelp=2.0.0"
    "sphinxcontrib-htmlhelp=2.1.0" "sphinxcontrib-jsmath=1.0.1"
    "sphinxcontrib-qthelp=2.0.0" "sphinxcontrib-serializinghtml=2.0.0"
    "tomli=2.0.2" "tomlkit=0.13.2" "watchdog=5.0.3" "zarr=2.10.3"
)

# Log files
found_log="found_packages.log"
not_found_log="not_found_packages.log"

# Clear previous logs
> "$found_log"
> "$not_found_log"

# Check each package
for package in "${packages[@]}"; do
    echo "Checking $package..."
    
    # Search for the package and capture the output and status
    output=$(conda search "$package" 2>/dev/null)
    if [ $? -eq 0 ]; then
        # Package found; extract channel information
        channel=$(echo "$output" | grep -m1 'channel' | awk '{print $3}')
        echo "$package found in channel: $channel" >> "$found_log"
    else
        # Package not found
        echo "$package NOT found in current Conda channels" >> "$not_found_log"
    fi
done

echo "Search completed. Check $found_log and $not_found_log for results."
